----------------
title : C 언어 레퍼런스 - strtok 함수
cat_title :  strtok
publish_date : 2010-11-27
ref_title : strtok
path : /C Reference/string.h
--------------



```warning
아직 C 언어와 친숙하지 않다면, [씹어먹는 C 언어 강좌](http://itguru.tistory.com/notice/15)를 보는 것이 어떻까요?

```

#@ strtok

```cpp
#include <string.h> // C++ 에서는 <cstring>

char * strtok ( char * str, const char * delimiters );
```

문자열을 토큰들로 분리한다.

이 함수를 여러분 호출함해서 문자열을 토큰들로 분리할 수 있다. 이 때 토큰(token) 은 구분문자(delimiter) 로 쪼개진 문자열 조각을 의미한다.

이 함수에 `str` 에 쪼개고자 하는 문자열을 전달하면 `str` 의 첫번째 문자 부터 토큰들의 위치를 찾아내게 된다. 이 다음에 인자로 `NULL` 을 전달하며 함수를 호출하게 된다면 이전에 찾았던 토큰 바로 다음 문자 부터 시작하여 토큰들의 위치를 찾게 된다.

토큰들의 시작과 끝을 결정하기 위해서 `strtok` 함수는 구분 문자를 포함하지 않는 가장 첫번째 문자 부터 (이 문자가 토큰의 시작이 된다) 그 다음으로 등장하는 첫번째 구분 문자가 토큰의 마지막이 된다. 이 때, 토큰의 마지막은 (구분 문자가 있었을 곳) 은 함수에 의해 널 문자로 바뀌며 이 토큰의 시작 주소가 리턴된다.

만일 `strtok` 에서 맨 처음에 `str` 에 인자로 전달하였던 문자열의 종료 널 문자에 도달하게 된다면 그 후의 `str` 에 널을 전달하는 모든 호출에서는 널 포인터를 리턴하게 된다. 물론 나중에 `str` 에 다른 문자열을 전달한다면 그 문자열을 토큰으로 분리하기 시작할 것이다.



###  인자

`str`

토큰으로 불리할 C 형식 문자열이다. 만일 기존에 `str` 에 전달하였던 문자열을 계속 토큰으로 분리해 나가고 싶다면 `str` 에 널을 전달하면 된다.

`delimiters`

구분 문자들을 포함하고 있는 C 형식 문자열이다.



###  리턴값




문자열에서 찾은 마지막 토큰의 주소값을 리턴하며 토큰이 더이상 없다면 널 포인터를 리턴한다.



###  구현 예


```cpp-formatted
/*

이 소스는
http://research.microsoft.com/en-us/um/redmond/projects/invisible/src/crt/strtok.c.htm
에서 가져왔습니다.

*/

char *__cdecl strtok(char *s1, const char *delimit) {
  static char *lastToken = NULL; /* UNSAFE SHARED STATE! */
  char *tmp;                     /* Skip leading delimiters if new string. */
  if (s1 == NULL) {
    s1 = lastToken;
    if (s1 == NULL) /* End of story? */
      return NULL;
  } else {
    s1 += strspn(s1, delimit);
  } /* Find end of segment */
  tmp = strpbrk(s1, delimit);
  if (tmp) { /* Found another delimiter, split string and save state. */
    *tmp = '\0';
    lastToken = tmp + 1;
  } else { /* Last segment, remember that. */
    lastToken = NULL;
  }
  return s1;
}
```




###  실행 예제


```cpp-formatted
/*' ', ',', '-', '.' 들을 구분 문자로 이용하여 - This, a sample string. 이라는
 * 문자열을 토큰들로 분리한다.이 예제는
 * http://www.cplusplus.com/reference/clibrary/cstring/strtok/ 에서 가져왔습니다
 */
#include <stdio.h>
#include <string.h>
int main() {
  char str[] = "- This, a sample string.";
  char* pch;
  printf("Splitting string \"%s\" into tokens:\n", str);
  pch = strtok(str, " ,.-");
  while (pch != NULL) {
    printf("%s\n", pch);
    pch = strtok(NULL, " ,.-");
  }
  return 0;
}
```


실행 결과


![](http://img1.daumcdn.net/thumb/R1920x0/?fname=http%3A%2F%2Fcfile30.uf.tistory.com%2Fimage%2F1415910C4CF0E82149948F)




###  참고 자료
* [strcspn](http://itguru.tistory.com/94)  :  특정한 문자를 찾을 때 까지의 길이를 구한다.
* [strpbrk](http://itguru.tistory.com/95)  :  문자열에서 특정한 문자를 찾는다.